/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectShortHashMap;
import gnu.trove.TObjectShortIterator;
import gnu.trove.decorator.TObjectShortHashMapDecorator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TObjectShortHashMapDecorator
extends AbstractMap
implements Map,
Cloneable {
    protected TObjectShortHashMap _map;

    public TObjectShortHashMapDecorator(TObjectShortHashMap map) {
        this._map = map;
    }

    public Object clone() {
        try {
            TObjectShortHashMapDecorator copy = (TObjectShortHashMapDecorator)super.clone();
            copy._map = (TObjectShortHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Object && val instanceof Short) {
                    Object k = this.unwrapKey(key);
                    short v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Object k = this.unwrapKey(key);
        short v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return TObjectShortHashMapDecorator.this._map.size();
            }

            public boolean isEmpty() {
                return TObjectShortHashMapDecorator.this.isEmpty();
            }

            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectShortHashMapDecorator.this.containsKey(k) && TObjectShortHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    private final TObjectShortIterator it;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.it = 1.access$000(this.this$1)._map.iterator();
                    }

                    public Object next() {
                        this.it.advance();
                        Object key = 1.access$000(this.this$1).wrapKey(this.it.key());
                        Short v = 1.access$000(this.this$1).wrapValue(this.it.value());
                        return new Map.Entry(this, v, key){
                            private Object val;
                            private final /* synthetic */ Object val$v;
                            private final /* synthetic */ Object val$key;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$v = val$v;
                                this.val$key = val$key;
                                this.val = this.val$v;
                            }

                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(this.val$key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            public Object getKey() {
                                return this.val$key;
                            }

                            public Object getValue() {
                                return this.val;
                            }

                            public int hashCode() {
                                return this.val$key.hashCode() + this.val.hashCode();
                            }

                            public Object setValue(Object value) {
                                this.val = value;
                                return 1.access$000(2.access$100(this.this$2)).put(this.val$key, value);
                            }
                        };
                    }

                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    public void remove() {
                        this.it.remove();
                    }

                    static /* synthetic */ 1 access$100(2 x0) {
                        return x0.this$1;
                    }
                };
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                TObjectShortHashMapDecorator.this.clear();
            }

            static /* synthetic */ TObjectShortHashMapDecorator access$000(1 x0) {
                return x0.TObjectShortHashMapDecorator.this;
            }
        };
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final Object wrapKey(Object o) {
        return o;
    }

    protected final Object unwrapKey(Object key) {
        return key;
    }

    protected Short wrapValue(short k) {
        return new Short(k);
    }

    protected short unwrapValue(Object value) {
        return (Short)value;
    }
}

