/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.collections.map.SoftHashMap;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileSparseObjectMatrix
extends AbstractSparseObjectMatrix {
    private static final long serialVersionUID = 392817709394048419L;
    private final Map<Coordinates, Object> values = new SoftHashMap<Coordinates, Object>();

    public VolatileSparseObjectMatrix(Matrix m) {
        super(m.getSize());
        this.size = Coordinates.copyOf(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        throw new RuntimeException("not implemented");
    }

    public VolatileSparseObjectMatrix(long ... size) {
        super(size);
        this.size = Coordinates.copyOf(size);
    }

    @Override
    public final void clear() {
        this.values.clear();
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.values.get(Coordinates.wrap(coordinates));
    }

    @Override
    public long getValueCount() {
        return this.values.size();
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        this.values.put(Coordinates.wrap(coordinates).clone(), value);
    }

    public Iterable<long[]> entries() {
        return new CoordinateSetToLongWrapper(this.values.keySet());
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.values.containsKey(Coordinates.wrap(coordinates));
    }
}

