/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransposeDenseMatrix2D
implements TransposeCalculation<DenseMatrix2D, DenseMatrix2D> {
    TransposeDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            Transpose.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, (DenseDoubleMatrix2D)target);
        } else {
            VerifyUtil.verify2D(source);
            VerifyUtil.verify2D(target);
            VerifyUtil.verifyEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
            VerifyUtil.verifyEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    Object o = source.getAsObject(r, c);
                    target.setAsObject(o, c, r);
                }
            }
        }
    }
}

