/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.Maths;

public class PCA
extends AbstractAlgorithm {
    private boolean stop = false;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        FloatMatrix floatMatrix = algorithmData.getMatrix("experiment");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n7 = algorithmParameters.getInt("distance-function", 3);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        int n8 = algorithmParameters.getInt("pca-mode", 0);
        int n9 = floatMatrix.getRowDimension();
        int n10 = floatMatrix.getColumnDimension();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 2, 0);
        int n11 = 0;
        algorithmEvent.setIntValue(n11);
        algorithmEvent.setDescription("Calculate covariance matrix\n");
        this.fireValueChanged(algorithmEvent);
        FloatMatrix floatMatrix2 = new FloatMatrix(n9, n10);
        for (int i = 0; i < n9; ++i) {
            for (n6 = 0; n6 < n10; ++n6) {
                if (!Float.isNaN(floatMatrix.get(i, n6))) {
                    floatMatrix2.set(i, n6, floatMatrix.get(i, n6));
                    continue;
                }
                floatMatrix2.set(i, n6, 0.0f);
            }
        }
        FloatMatrix floatMatrix3 = null;
        if (n8 == 0) {
            floatMatrix3 = floatMatrix2;
        } else {
            floatMatrix3 = new FloatMatrix(n10, n10);
            for (n6 = 0; n6 < n10; ++n6) {
                for (n5 = 0; n5 < n10; ++n5) {
                    floatMatrix3.set(n5, n6, ExperimentUtil.distance(floatMatrix, n5, n6, n7, f, bl));
                }
            }
        }
        float[][] fArray = floatMatrix3.getArrayCopy();
        n5 = floatMatrix3.getRowDimension();
        int n12 = floatMatrix3.getColumnDimension();
        int n13 = Math.min(n5, n12);
        float[] fArray2 = new float[Math.min(n5 + 1, n12)];
        int[] nArray = new int[Math.min(n5 + 1, n12)];
        float[][] fArray3 = new float[n5][n13];
        float[][] fArray4 = new float[n12][n12];
        float[] fArray5 = new float[n12];
        float[] fArray6 = new float[n5];
        boolean bl2 = true;
        boolean bl3 = true;
        int n14 = Math.min(n5 - 1, n12);
        int n15 = Math.max(0, Math.min(n12 - 2, n5));
        for (n4 = 0; n4 < Math.min(n5 + 1, n12); ++n4) {
            nArray[n4] = n4;
        }
        algorithmEvent.setIntValue(++n11);
        algorithmEvent.setDescription("Reducing A to bidiagonal form\n");
        this.fireValueChanged(algorithmEvent);
        n4 = 0;
        for (n3 = 0; n3 < Math.max(n14, n15); ++n3) {
            int n16;
            ++n4;
            if (n3 < n14) {
                fArray2[n3] = 0.0f;
                for (n2 = n3; n2 < n5; ++n2) {
                    fArray2[n3] = Maths.hypot(fArray2[n3], fArray[n2][n3]);
                }
                if ((double)fArray2[n3] != 0.0) {
                    if ((double)fArray[n3][n3] < 0.0) {
                        fArray2[n3] = -fArray2[n3];
                    }
                    for (n2 = n3; n2 < n5; ++n2) {
                        float[] fArray7 = fArray[n2];
                        int n17 = n3;
                        fArray7[n17] = fArray7[n17] / fArray2[n3];
                    }
                    float[] fArray8 = fArray[n3];
                    int n18 = n3;
                    fArray8[n18] = (float)((double)fArray8[n18] + 1.0);
                }
                fArray2[n3] = -fArray2[n3];
            }
            for (n2 = n3 + 1; n2 < n12; ++n2) {
                if (n3 < n14 & (double)fArray2[n3] != 0.0) {
                    float f2 = 0.0f;
                    for (n16 = n3; n16 < n5; ++n16) {
                        f2 += fArray[n16][n3] * fArray[n16][n2];
                    }
                    f2 = -f2 / fArray[n3][n3];
                    for (n16 = n3; n16 < n5; ++n16) {
                        float[] fArray9 = fArray[n16];
                        int n19 = n2;
                        fArray9[n19] = fArray9[n19] + f2 * fArray[n16][n3];
                    }
                }
                fArray5[n2] = fArray[n3][n2];
            }
            if (bl2 & n3 < n14) {
                for (n2 = n3; n2 < n5; ++n2) {
                    fArray3[n2][n3] = fArray[n2][n3];
                }
            }
            if (n3 >= n15) continue;
            fArray5[n3] = 0.0f;
            for (n2 = n3 + 1; n2 < n12; ++n2) {
                fArray5[n3] = Maths.hypot(fArray5[n3], fArray5[n2]);
            }
            if ((double)fArray5[n3] != 0.0) {
                if ((double)fArray5[n3 + 1] < 0.0) {
                    fArray5[n3] = -fArray5[n3];
                }
                n2 = n3 + 1;
                while (n2 < n12) {
                    int n20 = n2++;
                    fArray5[n20] = fArray5[n20] / fArray5[n3];
                }
                int n21 = n3 + 1;
                fArray5[n21] = (float)((double)fArray5[n21] + 1.0);
            }
            fArray5[n3] = -fArray5[n3];
            if (n3 + 1 < n5 & (double)fArray5[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < n5; ++n2) {
                    fArray6[n2] = 0.0f;
                }
                for (n2 = n3 + 1; n2 < n12; ++n2) {
                    for (int i = n3 + 1; i < n5; ++i) {
                        int n22 = i;
                        fArray6[n22] = fArray6[n22] + fArray5[n2] * fArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < n12; ++n2) {
                    float f3 = -fArray5[n2] / fArray5[n3 + 1];
                    for (n16 = n3 + 1; n16 < n5; ++n16) {
                        float[] fArray10 = fArray[n16];
                        int n23 = n2;
                        fArray10[n23] = fArray10[n23] + f3 * fArray6[n16];
                    }
                }
            }
            if (!bl3) continue;
            for (n2 = n3 + 1; n2 < n12; ++n2) {
                fArray4[n2][n3] = fArray5[n2];
            }
        }
        n3 = Math.min(n12, n5 + 1);
        if (n14 < n12) {
            fArray2[n14] = fArray[n14][n14];
        }
        if (n5 < n3) {
            fArray2[n3 - 1] = 0.0f;
        }
        if (n15 + 1 < n3) {
            fArray5[n15] = fArray[n15][n3 - 1];
        }
        fArray5[n3 - 1] = 0.0f;
        if (bl2) {
            algorithmEvent.setDescription("Generating Matrix U\n");
            algorithmEvent.setIntValue(++n11);
            this.fireValueChanged(algorithmEvent);
            for (n2 = n14; n2 < n13; ++n2) {
                for (int i = 0; i < n5; ++i) {
                    fArray3[i][n2] = 0.0f;
                }
                fArray3[n2][n2] = 1.0f;
            }
            for (n2 = n14 - 1; n2 >= 0; --n2) {
                int n24;
                if ((double)fArray2[n2] != 0.0) {
                    for (n24 = n2 + 1; n24 < n13; ++n24) {
                        float f4 = 0.0f;
                        for (n = n2; n < n5; ++n) {
                            f4 += fArray3[n][n2] * fArray3[n][n24];
                        }
                        f4 = -f4 / fArray3[n2][n2];
                        for (n = n2; n < n5; ++n) {
                            float[] fArray11 = fArray3[n];
                            int n25 = n24;
                            fArray11[n25] = fArray11[n25] + f4 * fArray3[n][n2];
                        }
                    }
                    for (n24 = n2; n24 < n5; ++n24) {
                        fArray3[n24][n2] = -fArray3[n24][n2];
                    }
                    fArray3[n2][n2] = 1.0f + fArray3[n2][n2];
                    for (n24 = 0; n24 < n2 - 1; ++n24) {
                        fArray3[n24][n2] = 0.0f;
                    }
                    continue;
                }
                for (n24 = 0; n24 < n5; ++n24) {
                    fArray3[n24][n2] = 0.0f;
                }
                fArray3[n2][n2] = 1.0f;
            }
        }
        if (bl3) {
            algorithmEvent.setDescription("Generating Matrix V\n");
            algorithmEvent.setIntValue(++n11);
            this.fireValueChanged(algorithmEvent);
            for (n2 = n12 - 1; n2 >= 0; --n2) {
                int n26;
                if (n2 < n15 & (double)fArray5[n2] != 0.0) {
                    for (n26 = n2 + 1; n26 < n13; ++n26) {
                        float f5 = 0.0f;
                        for (n = n2 + 1; n < n12; ++n) {
                            f5 += fArray4[n][n2] * fArray4[n][n26];
                        }
                        f5 = -f5 / fArray4[n2 + 1][n2];
                        for (n = n2 + 1; n < n12; ++n) {
                            float[] fArray12 = fArray4[n];
                            int n27 = n26;
                            fArray12[n27] = fArray12[n27] + f5 * fArray4[n][n2];
                        }
                    }
                }
                for (n26 = 0; n26 < n12; ++n26) {
                    fArray4[n26][n2] = 0.0f;
                }
                fArray4[n2][n2] = 1.0f;
            }
        }
        n2 = n3 - 1;
        int n28 = 0;
        float f6 = (float)Math.pow(2.0, -52.0);
        algorithmEvent.setDescription("Main iteration loop started...\n");
        algorithmEvent.setIntValue(++n11);
        this.fireValueChanged(algorithmEvent);
        n4 = 0;
        while (n3 > 0) {
            float f7;
            int n29;
            int n30;
            if (++n4 == 240) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setDescription("Main iteration loop.\n");
                algorithmEvent.setIntValue(++n11);
                this.fireValueChanged(algorithmEvent);
                n4 = 0;
            }
            for (n = n3 - 2; n >= -1 && n != -1; --n) {
                if (!(Math.abs(fArray5[n]) <= f6 * (Math.abs(fArray2[n]) + Math.abs(fArray2[n + 1])))) continue;
                fArray5[n] = 0.0f;
                break;
            }
            if (n == n3 - 2) {
                n30 = 4;
            } else {
                for (n29 = n3 - 1; n29 >= n && n29 != n; --n29) {
                    f7 = (float)((n29 != n3 ? (double)Math.abs(fArray5[n29]) : 0.0) + (n29 != n + 1 ? (double)Math.abs(fArray5[n29 - 1]) : 0.0));
                    if (!(Math.abs(fArray2[n29]) <= f6 * f7)) continue;
                    fArray2[n29] = 0.0f;
                    break;
                }
                if (n29 == n) {
                    n30 = 3;
                } else if (n29 == n3 - 1) {
                    n30 = 1;
                } else {
                    n30 = 2;
                    n = n29;
                }
            }
            ++n;
            switch (n30) {
                case 1: {
                    float f8;
                    float f9;
                    float f10;
                    float f11 = fArray5[n3 - 2];
                    fArray5[n3 - 2] = 0.0f;
                    for (int i = n3 - 2; i >= n; --i) {
                        f10 = Maths.hypot(fArray2[i], f11);
                        f9 = fArray2[i] / f10;
                        f8 = f11 / f10;
                        fArray2[i] = f10;
                        if (i != n) {
                            f11 = -f8 * fArray5[i - 1];
                            fArray5[i - 1] = f9 * fArray5[i - 1];
                        }
                        if (!bl3) continue;
                        for (int j = 0; j < n12; ++j) {
                            f10 = f9 * fArray4[j][i] + f8 * fArray4[j][n3 - 1];
                            fArray4[j][n3 - 1] = -f8 * fArray4[j][i] + f9 * fArray4[j][n3 - 1];
                            fArray4[j][i] = f10;
                        }
                    }
                    break;
                }
                case 2: {
                    float f8;
                    float f9;
                    float f10;
                    float f12 = fArray5[n - 1];
                    fArray5[n - 1] = 0.0f;
                    for (int i = n; i < n3; ++i) {
                        f10 = Maths.hypot(fArray2[i], f12);
                        f9 = fArray2[i] / f10;
                        f8 = f12 / f10;
                        fArray2[i] = f10;
                        f12 = -f8 * fArray5[i];
                        fArray5[i] = f9 * fArray5[i];
                        if (!bl2) continue;
                        for (int j = 0; j < n5; ++j) {
                            f10 = f9 * fArray3[j][i] + f8 * fArray3[j][n - 1];
                            fArray3[j][n - 1] = -f8 * fArray3[j][i] + f9 * fArray3[j][n - 1];
                            fArray3[j][i] = f10;
                        }
                    }
                    break;
                }
                case 3: {
                    float f13 = Math.max(Math.max(Math.max(Math.max(Math.abs(fArray2[n3 - 1]), Math.abs(fArray2[n3 - 2])), Math.abs(fArray5[n3 - 2])), Math.abs(fArray2[n])), Math.abs(fArray5[n]));
                    f7 = fArray2[n3 - 1] / f13;
                    float f10 = fArray2[n3 - 2] / f13;
                    float f9 = fArray5[n3 - 2] / f13;
                    float f8 = fArray2[n] / f13;
                    float f14 = fArray5[n] / f13;
                    float f15 = ((f10 + f7) * (f10 - f7) + f9 * f9) / 2.0f;
                    float f16 = f7 * f9 * (f7 * f9);
                    float f17 = 0.0f;
                    if ((double)f15 != 0.0 | (double)f16 != 0.0) {
                        f17 = (float)Math.sqrt(f15 * f15 + f16);
                        if ((double)f15 < 0.0) {
                            f17 = -f17;
                        }
                        f17 = f16 / (f15 + f17);
                    }
                    float f18 = (f8 + f7) * (f8 - f7) + f17;
                    float f19 = f8 * f14;
                    for (int i = n; i < n3 - 1; ++i) {
                        int n31;
                        float f20 = Maths.hypot(f18, f19);
                        float f21 = f18 / f20;
                        float f22 = f19 / f20;
                        if (i != n) {
                            fArray5[i - 1] = f20;
                        }
                        f18 = f21 * fArray2[i] + f22 * fArray5[i];
                        fArray5[i] = f21 * fArray5[i] - f22 * fArray2[i];
                        f19 = f22 * fArray2[i + 1];
                        fArray2[i + 1] = f21 * fArray2[i + 1];
                        if (bl3) {
                            for (n31 = 0; n31 < n12; ++n31) {
                                f20 = f21 * fArray4[n31][i] + f22 * fArray4[n31][i + 1];
                                fArray4[n31][i + 1] = -f22 * fArray4[n31][i] + f21 * fArray4[n31][i + 1];
                                fArray4[n31][i] = f20;
                            }
                        }
                        f20 = Maths.hypot(f18, f19);
                        f21 = f18 / f20;
                        f22 = f19 / f20;
                        fArray2[i] = f20;
                        f18 = f21 * fArray5[i] + f22 * fArray2[i + 1];
                        fArray2[i + 1] = -f22 * fArray5[i] + f21 * fArray2[i + 1];
                        f19 = f22 * fArray5[i + 1];
                        fArray5[i + 1] = f21 * fArray5[i + 1];
                        if (!bl2 || i >= n5 - 1) continue;
                        for (n31 = 0; n31 < n5; ++n31) {
                            f20 = f21 * fArray3[n31][i] + f22 * fArray3[n31][i + 1];
                            fArray3[n31][i + 1] = -f22 * fArray3[n31][i] + f21 * fArray3[n31][i + 1];
                            fArray3[n31][i] = f20;
                        }
                    }
                    fArray5[n3 - 2] = f18;
                    ++n28;
                    break;
                }
                case 4: {
                    if ((double)fArray2[n] <= 0.0) {
                        float f23 = fArray2[n] = (double)fArray2[n] < 0.0 ? -fArray2[n] : 0.0f;
                        if (bl3) {
                            for (n29 = 0; n29 <= n2; ++n29) {
                                fArray4[n29][n] = -fArray4[n29][n];
                            }
                        }
                    }
                    while (n < n2 && !(fArray2[n] >= fArray2[n + 1])) {
                        int n32;
                        float f24 = fArray2[n];
                        fArray2[n] = fArray2[n + 1];
                        fArray2[n + 1] = f24;
                        int n33 = nArray[n];
                        nArray[n] = nArray[n + 1];
                        nArray[n + 1] = n33;
                        if (bl3 && n < n12 - 1) {
                            for (n32 = 0; n32 < n12; ++n32) {
                                f24 = fArray4[n32][n + 1];
                                fArray4[n32][n + 1] = fArray4[n32][n];
                                fArray4[n32][n] = f24;
                            }
                        }
                        if (bl2 && n < n5 - 1) {
                            for (n32 = 0; n32 < n5; ++n32) {
                                f24 = fArray3[n32][n + 1];
                                fArray3[n32][n + 1] = fArray3[n32][n];
                                fArray3[n32][n] = f24;
                            }
                        }
                        ++n;
                    }
                    n28 = 0;
                    --n3;
                }
            }
        }
        algorithmEvent.setDescription("End SVD calculation.\n");
        algorithmEvent.setIntValue(++n11);
        this.fireValueChanged(algorithmEvent);
        FloatMatrix floatMatrix4 = new FloatMatrix(fArray3, n5, Math.min(n5 + 1, n12));
        FloatMatrix floatMatrix5 = new FloatMatrix(fArray4, n12, n12);
        FloatMatrix floatMatrix6 = new FloatMatrix(n12, n12);
        float[][] fArray13 = floatMatrix6.getArray();
        for (int i = 0; i < n12; ++i) {
            for (int j = 0; j < n12; ++j) {
                fArray13[i][j] = 0.0f;
            }
            fArray13[i][i] = fArray2[i];
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        switch (n8) {
            case 0: {
                break;
            }
            case 1: {
                algorithmData2.addMatrix("U", floatMatrix2.times(floatMatrix4));
                break;
            }
            case 2: {
                algorithmData2.addMatrix("U", floatMatrix2.transpose().times(floatMatrix4));
                break;
            }
            case 3: {
                FloatMatrix floatMatrix7 = floatMatrix4.copy();
                FloatMatrix floatMatrix8 = floatMatrix6.copy();
                int n34 = floatMatrix8.getRowDimension();
                for (int i = 0; i < n34; ++i) {
                    floatMatrix8.set(i, i, 1.0f / (float)Math.sqrt(floatMatrix8.get(i, i)));
                }
                floatMatrix4 = floatMatrix2.times(floatMatrix7.times(floatMatrix8));
                algorithmData2.addMatrix("U", floatMatrix2.transpose().times(floatMatrix4));
                break;
            }
        }
        algorithmData2.addMatrix("T", floatMatrix4);
        algorithmData2.addMatrix("S", floatMatrix6);
        algorithmData2.addMatrix("V", floatMatrix5);
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }
}

