/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;
import org.genepattern.annotation.FeatureClassEditor;
import org.genepattern.annotation.SampleClassEditor;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.module.VisualizerUtil;
import org.genepattern.uiutil.UIUtil;

public class SetAnnotator {
    private SparseClassVector classVector = new SparseClassVector();
    private int classNumberCounter = 0;
    private static final Color[] colors = new Color[]{Color.red, Color.yellow, Color.blue, Color.GREEN, Color.ORANGE, Color.magenta, Color.CYAN, Color.PINK, Color.GRAY};
    private boolean annotateRow = true;
    private SetAnnotatorModel model;
    private SampleClassEditor sampleClassEditor;
    private FeatureClassEditor featureClassEditor;
    private JMenuItem openFeaturesMenuItem;
    private JMenuItem viewFeatureListsMenuItem;
    private JTable table;

    public SparseClassVector getClassVector() {
        return this.classVector;
    }

    public SetAnnotator(final Frame parent, final SetAnnotatorModel model, boolean _annotateRow) {
        this.model = model;
        this.annotateRow = _annotateRow;
        this.viewFeatureListsMenuItem = this.annotateRow ? new JMenuItem("Feature Annotations...") : new JMenuItem("Sample Annotations...");
        this.viewFeatureListsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetAnnotator.this.annotateRow) {
                    if (SetAnnotator.this.featureClassEditor == null || !SetAnnotator.this.featureClassEditor.isShowing()) {
                        SetAnnotator.this.featureClassEditor = new FeatureClassEditor(parent, model, SetAnnotator.this.classVector);
                    }
                } else if (SetAnnotator.this.sampleClassEditor == null || !SetAnnotator.this.sampleClassEditor.isShowing()) {
                    SetAnnotator.this.sampleClassEditor = new SampleClassEditor(parent, model, SetAnnotator.this.classVector);
                }
            }
        });
        this.openFeaturesMenuItem = this.annotateRow ? new JMenuItem("Open Feature List(s)...") : new JMenuItem("Open Cls File...");
        this.openFeaturesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = SetAnnotator.this.annotateRow ? "Select Feature List(s)" : "Select Cls File";
                File f = SetAnnotator.this.showOpenDialog(parent, title);
                if (f == null) {
                    return;
                }
                String extension = FilenameUtils.getExtension((String)f.getName());
                try {
                    if (SetAnnotator.this.annotateRow) {
                        this.annotateRowsFromFile(parent, f, extension);
                    } else {
                        this.annotateSamplesFromFile(parent, model, f, extension);
                    }
                    if (SetAnnotator.this.table != null) {
                        SetAnnotator.this.table.invalidate();
                        SetAnnotator.this.table.validate();
                        SetAnnotator.this.table.repaint();
                    }
                }
                catch (Exception x) {
                    UIUtil.showErrorDialog(parent, "An error occurred while reading " + f.getName());
                }
            }

            private void annotateRowsFromFile(Frame parent2, File f, String extension) throws Exception {
                boolean missingFeatures = false;
                if (extension != null) {
                    if ((extension = extension.toLowerCase()).equals("gmt") || extension.equals("gmx")) {
                        GeneSetMatrix gmt = ParserFactory.readGeneSetMatrix(f, false);
                        int sets = gmt.getNumGeneSets();
                        for (int i = 0; i < sets; ++i) {
                            GeneSet set = gmt.getGeneSet(i);
                            boolean result = SetAnnotator.this.addToFeatureList(set.getMembers(), set.getName());
                            missingFeatures |= result;
                        }
                    } else if (extension.equals("grp")) {
                        GeneSet gset = ParserFactory.readGeneSet(f, false);
                        missingFeatures = SetAnnotator.this.addToFeatureList(gset.getMembers(), f.getName());
                    } else {
                        List<String> featureList = VisualizerUtil.readFeatureList(parent2, f.getCanonicalPath());
                        missingFeatures = SetAnnotator.this.addToFeatureList(featureList, f.getName());
                    }
                } else {
                    List<String> featureList = VisualizerUtil.readFeatureList(parent2, f.getCanonicalPath());
                    missingFeatures = SetAnnotator.this.addToFeatureList(featureList, f.getName());
                }
                if (missingFeatures) {
                    UIUtil.showMessageDialog(parent2, "Warning: The file contains features that are not found in the data set.");
                }
            }

            private void annotateSamplesFromFile(Frame parent2, SetAnnotatorModel model2, File f, String extension) throws Exception {
                int j;
                ClassVector cv = VisualizerUtil.readCls(parent2, f.getCanonicalPath());
                if (cv == null) {
                    return;
                }
                if (cv.size() != model2.getFeatureCount()) {
                    UIUtil.showErrorDialog(parent2, "The number of samples in the cls file (" + cv.size() + ") does not match the number of samples in the dataset (" + model2.getFeatureCount() + ").");
                    return;
                }
                ArrayList<Integer> group = new ArrayList<Integer>();
                for (j = 0; j < cv.getClassCount(); ++j) {
                    int index = j + SetAnnotator.this.classNumberCounter;
                    group.add(index);
                    SetAnnotator.this.classVector.setClass(new Integer(index), cv.getClassName(j), SetAnnotator.this.getNextClassColor(index));
                }
                SetAnnotator.this.classVector.addClassGroup(group, f.getName());
                for (j = 0; j < cv.size(); ++j) {
                    SetAnnotator.this.classVector.addClass(j, cv.getAssignment(j) + SetAnnotator.this.classNumberCounter);
                }
                SetAnnotator.this.classVector.notifyListeners();
                SetAnnotator.this.classNumberCounter += cv.getClassCount();
            }
        });
        if (this.annotateRow && parent != null) {
            this.openFeaturesMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    private File showOpenDialog(Frame parent, String title) {
        if (title == null) {
            title = "GSEA";
        }
        FileDialog fOpenDialog = Application.getFileManager().getSetAnnotatorFileDialog();
        fOpenDialog.setTitle(title);
        fOpenDialog.setVisible(true);
        File[] files = fOpenDialog.getFiles();
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    private boolean addToFeatureList(List<String> featureList, String className) {
        boolean missingFeatures = false;
        for (String feature : featureList) {
            int index = this.model.getIndex(feature);
            if (index < 0) {
                missingFeatures = true;
                continue;
            }
            this.classVector.addClass(index, this.classNumberCounter);
        }
        this.classVector.setClass(this.classNumberCounter, className, this.getNextClassColor(this.classNumberCounter));
        ++this.classNumberCounter;
        return missingFeatures;
    }

    private Color getNextClassColor(int index) {
        if (index >= colors.length) {
            return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        }
        return colors[this.classNumberCounter];
    }

    public JMenuItem getOpenFeaturesMenuItem() {
        return this.openFeaturesMenuItem;
    }

    public JMenuItem getViewFeatureListsMenuItem() {
        return this.viewFeatureListsMenuItem;
    }
}

