/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.interfaces.HasToolTip;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;

public abstract class AbstractPanel
extends JPanel
implements HasToolTip,
CanBeRepainted {
    private static final long serialVersionUID = 4748216534779867441L;
    private final GUIObject guiObject;

    public AbstractPanel(GUIObject o) {
        this.guiObject = o;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(800, 600));
        this.setSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void paintToBuffer(BufferedImage image) {
    }

    public GUIObject getGUIObject() {
        return this.guiObject;
    }

    protected void finalize() throws Throwable {
        ToolTipManager.sharedInstance().unregisterComponent(this);
        super.finalize();
    }

    public final void exportToJPEG(File file) {
        ExportJPEG.save(file, (Component)this);
    }

    public final void exportToPDF(File file) {
        ExportPDF.save(file, this);
    }

    public final void exportToPNG(File file) {
        ExportPNG.save(file, (Component)this);
    }

    public String getToolTipText() {
        return this.guiObject.getToolTipText();
    }

    public void repaintUI() {
    }
}

